// tree234.java
// demonstracja drzewa 234
// aby uruchomi program: C>java Tree234App
import java.io.*;
////////////////////////////////////////////////////////////////
class DataItem
   {
   public long dData;          // pojedynczyelement danych
//--------------------------------------------------------------
   public DataItem(long dd)    // konstruktor
      { dData = dd; }
//--------------------------------------------------------------
   public void displayItem()   // wywietlanie elementu, format "/27"
      { System.out.print("/"+dData); }
//--------------------------------------------------------------
   }  // end class DataItem
////////////////////////////////////////////////////////////////
class Node
   {
   private static final int ORDER = 4;
   private int numItems;
   private Node parent;
   private Node childArray[] = new Node[ORDER];
   private DataItem itemArray[] = new DataItem[ORDER-1];
// -------------------------------------------------------------
   // przyczanie potomka do tego wza
   public void connectChild(int childNum, Node child)
      {
      childArray[childNum] = child;
      if(child != null)
         child.parent = this;
      }
// -------------------------------------------------------------
   // odczanie potomka od tego wza; zwracamy potomka
   public Node disconnectChild(int childNum)
      {
      Node tempNode = childArray[childNum];
      childArray[childNum] = null;
      return tempNode;
      }
// -------------------------------------------------------------
   public Node getChild(int childNum)
      { return childArray[childNum]; }
// -------------------------------------------------------------
   public Node getParent()
      { return parent; }
// -------------------------------------------------------------
   public boolean isLeaf()
      { return (childArray[0]==null) ? true : false; }
// -------------------------------------------------------------
   public int getNumItems()
     { return numItems; }
// -------------------------------------------------------------
   public DataItem getItem(int index)   // pobieranie DataItem o indeksie
      { return itemArray[index]; }
// -------------------------------------------------------------
   public boolean isFull()
      { return (numItems==ORDER-1) ? true : false; }
// -------------------------------------------------------------
   public int findItem(long key)       // zwracamy indeks
      {                                    // elementu (w wle),
      for(int j=0; j<ORDER-1; j++)         // jeeli zostanie znaleziony,
         {                                 // inaczej
         if(itemArray[j] == null)          // zwracamy -1
            break;
         else if(itemArray[j].dData == key)
            return j;
         }
      return -1;
      }  // end findItem
// -------------------------------------------------------------
   public int insertItem(DataItem newItem)
      {
      // zakadamy, e wze nie jest peny
      numItems++;                          // dodamy nowy element
      long newKey = newItem.dData;         // klucz nowego elementu

      for(int j=ORDER-2; j>=0; j--)        // zaczynamy od prawej,
         {                                 // badamy elementy
         if(itemArray[j] == null)          // jezeli pusty,
            continue;                      // przechodzimy o jeden element w lewo
         else                              // jezeli nie jest pusty,
            {                              // pobieramy klucz
            long itsKey = itemArray[j].dData;
            if(newKey < itsKey)            // jezeli jest wiekszy
               itemArray[j+1] = itemArray[j]; // przesuwamy element w prawo
            else
               {
               itemArray[j+1] = newItem;   // wstawiamy nowy element
               return j+1;                 // zwracamy indeks
               }                           //    nowego elementu
            }  // end else (not null)
         }  // end for                     // wszystkie elementy przesuniete
      itemArray[0] = newItem;              // wstawiamy nowy element
      return 0;
      }  // end insertItem()
// -------------------------------------------------------------
   public DataItem removeItem()        // usuwanie elementu danych o najwyszym kluczu
      {
      // zakadamy, ze wze nie jest pusty
      DataItem temp = itemArray[numItems-1];  // zapisujemy element
      itemArray[numItems-1] = null;           // odczamy element
      numItems--;                             // jeden element mniej
      return temp;                            // zwracamy element
      }
// -------------------------------------------------------------
   public void displayNode()           // format "/24/56/74/"
      {
      for(int j=0; j<numItems; j++)
         itemArray[j].displayItem();   // "/56"
      System.out.println("/");         // kocowy "/"
      }
// -------------------------------------------------------------
   }  // end class Node
////////////////////////////////////////////////////////////////
class Tree234
   {
   private Node root = new Node();            // tworzenie korzenia
// -------------------------------------------------------------
   public int find(long key)
      {
      Node curNode = root;
      int childNumber;
      while(true)
         {
         if(( childNumber=curNode.findItem(key) ) != -1)
            return childNumber;               // znaleziony
         else if( curNode.isLeaf() )
            return -1;                        // nie znaleziony
         else                                 // szukaj gbiej
            curNode = getNextChild(curNode, key);
         }  // end while
      }
// -------------------------------------------------------------
   // wstawienie DataItem
   public void insert(long dValue)
      {
      Node curNode = root;
      DataItem tempItem = new DataItem(dValue);

      while(true)
         {
         if( curNode.isFull() )               // jeeli wze peny,
            {
            split(curNode);                   // podziel
            curNode = curNode.getParent();    // wycofaj si
                                              // jeszcze raz
            curNode = getNextChild(curNode, dValue);
            }  // end if(node is full)

         else if( curNode.isLeaf() )          // jezeli wze jest liciem,
            break;                            // po prostu wstaw
         // wze nie jest peny i nie jest liciem, wic idziemy niej
         else
            curNode = getNextChild(curNode, dValue);
         }  // end while

      curNode.insertItem(tempItem);       // wstaw nowy element DataItem
      }  // end insert()
// -------------------------------------------------------------
   public void split(Node thisNode)     // podzial wezla thisNode
      {
      // assumes node is full
      DataItem itemB, itemC;
      Node parent, child2, child3;
      int itemIndex;

      itemC = thisNode.removeItem();    // usu elementy danych
      itemB = thisNode.removeItem();    // z tego wza
      child2 = thisNode.disconnectChild(2); // usu potomkw
      child3 = thisNode.disconnectChild(3); // z tego wza

      Node newRight = new Node();       // utwrz nowy wze

      if(thisNode==root)                // jeeli to korze,
         {
         root = new Node();                // utwrz nowy korze
         parent = root;                    // korze jest teraz naszym rodzicem
         root.connectChild(0, thisNode);   // przycz do rodzica
         }
      else                              // jeeli ten wze nie jest korzeniem
         parent = thisNode.getParent();    // pobierz rodzica

      // zaatw rodzica
      itemIndex = parent.insertItem(itemB); // element B do rodzica
      int n = parent.getNumItems();         // cakowita liczba elementw?

      for(int j=n-1; j>itemIndex; j--)          // przesu poczenia
         {                                      // rodzica
         Node temp = parent.disconnectChild(j); // o jednego potomka
         parent.connectChild(j+1, temp);        // w prawo
         }
                                   // przycz newRight do rodzica
      parent.connectChild(itemIndex+1, newRight);

      // zaatw newRight
      newRight.insertItem(itemC);       // element C do newRight
      newRight.connectChild(0, child2); // przyczamy jako 0 i 1
      newRight.connectChild(1, child3); // w newRight
      }  // end split()
// -------------------------------------------------------------
   // zwraca odwoanie do waciwego potomka w trakcie wyszukiwania wartoci
   public Node getNextChild(Node theNode, long theValue)
      {
      int j;
      // zakadamy, e wze nie jest peny, nie jest pusty i nie jest liciem
      int numItems = theNode.getNumItems();
      for(j=0; j<numItems; j++)          // dla kadego elementu danych wza
         {                               // jest mnieszy?
         if( theValue < theNode.getItem(j).dData )
            return theNode.getChild(j);  // zwracamy lewego potomka
         }  // end for                   // nasza warto wiksza, wic
      return theNode.getChild(j);        // zwracamy prawego potomka
      }
// -------------------------------------------------------------
   public void displayTree()
      {
      recDisplayTree(root, 0, 0);
      }
// -------------------------------------------------------------
   private void recDisplayTree(Node thisNode, int level,
                                              int childNumber)
      {
      System.out.print("level="+level+" child="+childNumber+" ");
      thisNode.displayNode();               // wywietl ten wze

      // wywoaj siebie dla kadego potomka tego wza
      int numItems = thisNode.getNumItems();
      for(int j=0; j<numItems+1; j++)
         {
         Node nextNode = thisNode.getChild(j);
         if(nextNode != null)
            recDisplayTree(nextNode, level+1, j);
         else
            return;
         }
      }  // end recDisplayTree()
// -------------------------------------------------------------\
   }  // end class Tree234
////////////////////////////////////////////////////////////////
class Tree234App
   {
   public static void main(String[] args) throws IOException
      {
      long value;
      Tree234 theTree = new Tree234();

      theTree.insert(50);
      theTree.insert(40);
      theTree.insert(60);
      theTree.insert(30);
      theTree.insert(70);

      while(true)
         {
         System.out.print("Wprowad pierwsz liter: ");
         System.out.print("Drzewo, Wstaw, Znajd: ");
         char choice = getChar();
         switch(choice)
            {
            case 'd':
               theTree.displayTree();
               break;
            case 'w':
               System.out.print("Wprowad warto: ");
               value = getInt();
               theTree.insert(value);
               break;
            case 'z':
               System.out.print("Wprowad warto: ");
               value = getInt();
               int found = theTree.find(value);
               if(found != -1)
                  System.out.println("Znaleziono "+value);
               else
                  System.out.println("Nie znaleziono "+value);
               break;
            default:
               System.out.print("Niewaciwy klawisz\n");
            }  // end switch
         }  // end while
      }  // end main()
//--------------------------------------------------------------
   public static String getString() throws IOException
      {
      InputStreamReader isr = new InputStreamReader(System.in);
      BufferedReader br = new BufferedReader(isr);
      String s = br.readLine();
      return s;
      }
//--------------------------------------------------------------
   public static char getChar() throws IOException
      {
      String s = getString();
      return s.charAt(0);
      }

//-------------------------------------------------------------
   public static int getInt() throws IOException
      {
      String s = getString();
      return Integer.parseInt(s);
      }
//-------------------------------------------------------------
   }  // end class Tree234App
////////////////////////////////////////////////////////////////
